# Notas de la Versión

## v3.87.95
- **Se ha corregido un error que se producía cuando el tamaño del video era desconocido:**:
  - Al analizar videos que devolvían de forma incorrecta o indeterminada el tamaño aproximado, se generaba una excepción.

## v3.87.94
- **Se ha corregido un error que impedía usar los botones**:  
  - El cambio al nuevo estilo de botones generó un error que los dejaba inoperativos. Ya debería estar solucionado.

## v3.87.93
- **Modificado el tipo de fuente en 'INFORMACIÓN DEL ENLACE' y 'ESTADO'**:  
  - Ambos textos ahora utilizan la fuente Segoe UI, más apropiada, moderna y legible.
- **Modificado el tipo de fuente y estilo en el 'Menú de Herramientas'**:  
  - Se ha sustituido por una fuente similar, aunque más moderna.
- **Cambiado el estilo de los botones**:  
  - Se les ha aplicado un estilo más plano y moderno.
- **Ajustada la colocación de los logotipos**:  
  - Se ha reposicionado los logotipos de las fuentes reconocidas para que no queden tan pegados a la esquina.
- **Ajustado el TabIndex y los cursores**:  
  - Se ha corregido el orden del TabIndex para que el foco salte correctamente.  
  - Se ha añadido el cambio del cursor a tipo HAND al pasar sobre los botones activos, mejorando la intuición de uso.
- **Corregida una excepción que ocurría en algunas páginas como DailyMotion**:  
  - La excepción se debía a una detección incorrecta del valor que indica si el contenido es en streaming o no.
- **Corregido un fallo menor en la descarga**:  
  - Al modificar la carpeta de descarga después del análisis, el archivo se descargaba en la ruta anterior.  
  - Ahora se desactiva el botón de descarga si se cambia el directorio, obligando al usuario a volver a analizar el enlace.
- **Corregido un error estético menor al seleccionar la carpeta de descarga**:  
  - La ventana de selección de carpeta ahora muestra correctamente la carpeta configurada anteriormente como ruta inicial.
- **Corregida una excepción al activar 'Trailer' seguido de 'Título Real'**:  
  - La excepción se producía por un fallo al preparar el archivo de guardado.  
  - Se ha añadido una validación para asegurar que todos los datos necesarios estén disponibles antes de ejecutar la acción.

## v3.87.84
- **Integración del logotipo de la plataforma al analizar un enlace:**
  - Al analizar un enlace, ahora se muestra también el logotipo de la plataforma correspondiente, lo que permite un reconocimiento más rápido y mejora la apariencia visual.
- **Opción para seleccionar la carpeta de descarga:**
  - Ya es posible elegir la carpeta de destino en la que se guardarán los vídeos descargados, ofreciendo así mayor flexibilidad al usuario.
- **Modificación del formulario de Lista de Compatibilidades:**
  - El formulario ha sido actualizado para mostrar la lista de compatibilidades mediante un DataGrid, proporcionando una presentación más clara y estructurada de los datos.
- **Corrección del error al detectar archivos descargados con título real:**
  - Se ha solucionado un error que impedía que la aplicación detectara correctamente los archivos descargados si se utilizaba el 'título real'.
  - Ahora, si el archivo ya ha sido descargado, el sistema lo reconoce y evita intentos fallidos de descarga repetida.
- **Corrección del error que provocaba lentitud en el análisis:**
  - Se ha corregido un problema de rendimiento causado por múltiples consultas al mismo enlace durante el análisis.
  - A partir de ahora, se realiza una única consulta eficiente, mejorando notablemente la velocidad de procesamiento.

## v3.82.82
- **Corregido un error en la traducción que impedía reconocer y traducir las palabras en las claves de los idiomas catalán, euskera y gallego:**
  - Se ha solucionado el problema que causaba que, al cambiar el idioma, este se mantuviera en el configurado por defecto, asegurando que los idiomas como catalán, euskera y gallego se reconozcan y traduzcan correctamente.
- **Corregido el aviso de error que aparecía por equivocación al introducir un enlace no válido:**
  - Se ha corregido el aviso de error que aparecía al analizar un enlace que no contiene video. Ahora el error se maneja internamente y no se muestra innecesariamente en pantalla.
- **Corregidas las claves en el diccionario, especialmente en catalán:**
  - Se han corregido las claves en el diccionario para asegurar que no solo el catalán, sino también otros idiomas como el euskera, se apliquen correctamente.
- **Implementada una nueva función de acceso al servidor:**
  - Se ha implementado una nueva función para acceder al servidor, lo que permitirá gestionar algunos errores de manera diferente y mostrar información más detallada al usuario.
- **Modificada la función de versión de FFMPEG:**
  - Se ha adaptado la función para que sea compatible también con versiones más recientes de FFMPEG, mejorando la compatibilidad del sistema.

## v3.82.76
- **Añadida la opción de cambio de idioma:**
  - Inicialmente, se incluyen las opciones de inglés y español.
- **Incorporación de 10 nuevos idiomas:**
  - Se han añadido francés, alemán, portugués, italiano, ruso, chino simplificado, japonés, euskera, catalán y gallego.
- **Implementada la función de verificación de descargas:**
  - Ahora se comprueba si el archivo se ha descargado correctamente y se notifica al usuario.
- **Modificado el color del botón 'DESCARGAR' tras completar la descarga:**
  - De este modo, se indica al usuario que el vídeo ya ha sido descargado, evitando que olvide si ha pulsado el botón.
- **Verificada la descarga de Reels en Facebook:**
  - Se ha detectado y corregido un error en la nomenclatura de los archivos descargados que generaba este problema.
- **Optimizada la validación de enlaces introducidos por el usuario:**
  - Si el enlace no incluye 'https://', se añadirá automáticamente antes de verificar su validez.
- **Corregido un error en la integración del diccionario:**
  - Se ha solucionado un problema que impedía la correcta carga de los diccionarios actualizados.
- **Añadido un campo de versión al diccionario:**
  - Se ha incorporado un campo llamado 'versión' en el diccionario para garantizar la compatibilidad con la aplicación.
  - Si no coincide, se eliminará y se descargará una nueva versión.
- **Corregida la función de validación de nombres de archivo:**
  - Ahora se verifica correctamente si el nombre del archivo ya existe.
- **Implementado un diccionario base interno en inglés:**
  - Si el diccionario no está disponible o requiere una actualización obligatoria y la descarga falla, la aplicación cargará su propio diccionario base en inglés.
  - La opción de cambio de idioma seguirá activa, y la aplicación intentará descargar el idioma seleccionado en cada reinicio.

## v3.62.47
- **Corregido un error en la etiqueta de información que permitía la entrada de texto**:
  - La etiqueta permitía la entrada de texto, lo que no afectaba a la funcionalidad, pero sí a la estética del programa.

## v3.62.45
- **Corregido un error estético en la visualización del error de descarga**:
  - El mensaje se mostraba de manera incorrecta.

## v3.62.44
- **Mejorada la comprobación de la versión antes de acceder a 'Buscar Actualizaciones'**:
  - Ahora se verifica la versión sin necesidad de cerrar y reabrir la aplicación.
- **Formulario de 'Informar de un error' más intuitivo**:
  - Se cambiaron los colores del texto y del botón, y se mejoraron las indicaciones para hacerlo más claro y fácil de usar.
- **Cambio en el color del texto de 'Título de destino' al activar 'Título Original'**:
  - El texto ahora se oscurece al marcar esta opción, haciéndolo más fácil de identificar.
- **Corrección de errores estéticos menores**:
  - Se corrigieron faltas de ortografía y otros detalles menores.

## v3.62.39
- **Corrección en la conversión de videos**:
  - Se solucionó un error con la comprobación del título del archivo al convertir videos a otro formato.
- **Nueva opción en la barra de tareas para informar errores**:
  - Ahora los usuarios pueden enviar información sobre enlaces problemáticos o cualquier fallo.
  - Se implementó un sistema para clasificar los errores reportados (Compatibilidad de Plataforma, Enlace NO funciona, Notificar Error).
- **Consola de administración integrada**:
  - El administrador ahora usa una consola dentro de la aplicación, en lugar de una externa.
  - Se añadieron funciones estadísticas y gestión de la base de datos desde la misma consola.
  - Se ha añadido la gestión de la base de datos desde la consola con funciones CRUD.
- **Buscador JustWatch añadido a los botones de búsqueda**:
  - Se añadió JustWatch para más opciones de búsqueda.
- **Rediseño del actualizador de la app**:
  - El actualizador ahora usa el mismo sistema que el actualizador de dependencias.
- **Optimización y mejoras en el código**:
  - Se ajustaron problemas previos y se organizaron mejor las nuevas funciones.
- **Mejoras en la ventana de 'Actualizar Dependencias'**:
  - Se ajustó el mensaje que informa sobre el estado de las dependencias.
- **Creación automática de carpetas para listas**:
  - La aplicación ahora crea automáticamente una carpeta que no exista para almacenar las listas de videos.
- **Ajustes en los botones de operaciones**:
  - El botón de descarga cambia a 'ESPERE' con fondo rojo mientras se procesa.
  - El botón de analizar también cambia a 'ESPERE' durante el proceso.
- **Modo desarrollador con argumento 'debugmode'**:
  - Se añadió un argumento para facilitar el desarrollo en la versión de código fuente.
- **Corrección adicional en 'Actualizar Dependencias'**:
  - Se solucionó un problema en la detección de dependencias que impedía activar el botón de descarga cuando había una nueva versión disponible.
- **Mnemonics añadidos al menú superior**:
  - Ahora puedes usar atajos de teclado para acceder al menú (Ejemplo: ALT + A para 'Archivo').
- **Detección de fuentes de streaming añadida**:
  - La función 'Analizar' ahora detecta enlaces de streaming, incluso de plataformas no conocidas.
- **Optimización de la función de analizar/descargar videos**:
  - Se mejoró la función para verificar videos en streaming.
  
## v3.06.19
- **El PopUp de 'About' ahora se muestra como ventana (formulario)**:
  - Se ha rediseñado para darle un aspecto más profesional.
- **Corregido un error de seguridad al cerrar forzadamente la ventana de actualización**:
  - Aunque no afectaba al funcionamiento del programa, este error permitía que el usuario evitara las actualizaciones, lo que podía generar problemas de compatibilidad a largo plazo.
- **Ahora el TextBox de Título permite ejecutar automáticamente el Botón 1 al presionar Enter**:
  - Esto agiliza el proceso, eliminando la necesidad de pulsar manualmente el botón de búsqueda tras escribir el título.
- **Implementado un control interno de Modo Test**:
  - Permite trabajar con la aplicación en modo desarrollo sin afectar la base de datos.
- **La actualización ahora verifica y actualiza el archivo FFMPEG**:
  - Se garantiza que FFMPEG se mantenga actualizado para realizar conversiones en tiempo real sin inconvenientes del mismo modo que lo hace con YTDLP y UPDATE.
- **Se ha redistribuido la barra de herramientas para mejorar su organización**:
  - Ahora sigue mejor los estándares, facilitando su uso.
- **Las opciones de conversión a MKV y WEBM han sido deshabilitadas temporalmente**:
  - Debido a incompatibilidades actuales, estas opciones estarán inactivas hasta que una actualización las haga nuevamente operativas.
- **Añadidas las opciones 'Buscar Actualizaciones' y 'Buscar Dependencias'**:
  - Ahora los usuarios pueden actualizar el programa o sus dependencias manualmente sin necesidad de cerrarlo y volver a abrirlo.
- **Compatibilidad añadida para la descarga de listas de YouTube**:
  - Al introducir un enlace de lista de reproducción, el programa ahora preguntará si se desea descargar la lista completa o solo el vídeo actual.

## v2.95.16
- **Añadida opción de ChangeLog en el menú de ayuda**:
  - Esta nueva opción muestra una ventana similar a la de 'Compatibilidades', donde se listan las notas de la versión en tiempo real, recuperadas desde la base de datos.
- **Corregido error de seguridad en el cierre de ventanas**:
  - Implementado un control en los eventos FormClosing para evitar excepciones al realizar un cierre forzado de las ventanas, asegurando la estabilidad de la aplicación.
- **Evitado que la aplicación continúe durante las actualizaciones**:
  - Solucionado un defecto que mostraba la ventana de aceptación de condiciones antes de completar las actualizaciones.
- **Reestructuración del código hacia un diseño modular**:
  - Adaptado el código para trabajar con microservicios reutilizables, permitiendo que las funciones puedan ser compartidas eficientemente entre diferentes formularios, optimizando el rendimiento.
- **Mejorado el sistema interno de actualizaciones**:
  - Modificado el sistema para que sea más intuitivo e informativo. Ahora, si algún componente necesita actualización, se abrirá una ventana que informe al usuario sobre los cambios y espere su confirmación antes de proceder.
  - Evitado que el programa quede en estado de espera sin notificar al usuario durante las actualizaciones.
- **Corregido botón de enlace a página web**:
  - Actualizado el enlace del botón hacia la nueva dirección de la página web del programa, adaptándose a los cambios realizados en el sitio.

## v2.79.09
- **Implementada compatibilidad dinámica en la base de datos**:
  - La lista de compatibilidades ahora se actualiza en tiempo real (Plataforma, Compatibilidad, Streaming).
- **Añadida fecha de comprobación en la tabla dinámica**:
  - Se implementó un campo para registrar la fecha de revisión de la lista de compatibilidades, manteniéndola actualizada en tiempo real.
- **Modularizadas operaciones comunes**:
  - Se reorganizaron las operaciones para mejorar el código y permitir su reutilización.

## v2.72.09
- **Estilo del botón 'Descargar' actualizado**:
  - Ahora el botón tiene un diseño más llamativo, con un fondo verde y texto en color blanco para mejorar la visibilidad. Se ha eliminado el rojo, que daba sensación de error.
- **Validación de títulos**:
  - Corregido el problema donde al introducir listas y tiempos específicos de los videos podían dar conflictos en la descarga.
- **Optimización de la función de carga de ajustes**:
  - La carga de configuración de la aplicación se ha mejorado significativamente en términos de rendimiento.
- **Unificación de la muestra de mensajes**:
  - Los mensajes de la aplicación ahora se gestionan a través de una única función, optimizando el código y haciéndolo más legible.
- **Autoactualización para yt-dlp**:
  - La función de yt-dlp ahora se actualiza automáticamente cada vez que se lanzan nuevas versiones en las plataformas compatibles.
- **Compatibilidad a yt-dlp v2025.01.15**.
- **Sistema de actualizaciones rediseñado**:
  - La comprobación de versiones se realiza mediante hashes, dejando el control de versiones únicamente como información adicional para los usuarios.

## v2.68.03
- **Botones de acceso a buscadores web**:
  - Se añadieron más botones de acceso directo a buscadores web.
  - Los botones ahora permiten cambiar el icono desde la barra de tareas.
  - Implementación de validación para redirigir a funcionalidades específicas según el botón seleccionado.
- **Integración de la API para IPs**:
  - Migración de la integración de la API externa al servidor propio para corregir problemas con usuarios que tienen protecciones IP.
- **Archivo de configuración**:
  - Añadido soporte para un archivo de configuración que recuerda preferencias del usuario:
    - Opciones seleccionadas previamente.
    - Desactivación de notificaciones emergentes.
- **Validación de títulos**:
  - Corregido el problema donde ciertos caracteres en títulos de videos generaban incompatibilidades y bloqueos en la aplicación.
- **Compatibilidades**:
  - La lista de compatibilidades ahora se muestra en una nueva ventana o formulario en lugar de un MessageBox, para una mejor accesibilidad.
- **Sistema de comprobación de versión**:
  - Implementada una función que verifica la versión de la aplicación en cada análisis, previniendo errores causados por actualizaciones durante su uso.
- **Optimización de detección de fuentes de descarga**:
  - Mejoras en la detección de fuentes no compatibles, informando al usuario si la fuente es reconocida aunque no sea descargable.
  - Sistema insensible a mayúsculas y minúsculas para proporcionar respuestas más claras y específicas.
- **Donaciones**:
  - Añadida la opción de realizar donaciones a través de PayPal.
- **Compatibilidades comprobadas**:
  - **Normales**:
    - Facebook: Compatible.
    - Bilibili: Compatible.
    - Kick: Compatible (Streaming).
  - **Adultos**:
    - Chaturbate: Compatible (Streaming).
    - BongaCams: Compatible (Streaming).
    - Otras plataformas marcadas como NO compatibles o en evaluación.
- **Botón 'Descargar'**:
  - Se mejoró el diseño del botón para hacerlo más atractivo visualmente.
- **Información de YT-DLP**:
  - Añadida la fecha de la última actualización del ejecutable YT-DLP en el popup de compatibilidades.

## v2.58
- **Corrección de errores**:
  - Resuelta una excepción que ocurría al no localizar el archivo yt-dlp.exe.
  - Ajustados los mensajes de error y los cierres inesperados de la aplicación ante fallos críticos.
- **Mejoras visuales**:
  - Rediseñada la ventana de condiciones de uso para mejorar su visualización en dispositivos con resoluciones específicas.
- **Nuevas funciones**:
  - Incorporada una validación de nombres de archivo antes de la descarga para evitar errores de descarga por caracteres no válidos ( :, \", <, >, |, ?, *, /, ).
- **Base de datos**:
  - Ahora se registra también el título de los videos descargados, ampliando la información almacenada.
- **Optimización**:
  - Realizadas mejoras en el código para incrementar la eficiencia y la estabilidad del programa.

## v2.51
- Se ha corregido un error visual en el formulario que causaba desajustes al visualizarse en distintos dispositivos.

## v2.50
- Se ha completado la implementación de seguridad mediante un sistema de tokens y hashes para proteger los archivos.

## v2.34
- Se ha reescrito aproximadamente el 30% del código de la aplicación para mejorar la seguridad y solucionar problemas de vulnerabilidad.

## v2.24
- **Rediseño completo de la aplicación**:
  - Añadido menú de opciones.
  - Añadido botón para abrir la carpeta de descargas.
  - Las notificaciones ahora se pueden activar o desactivar desde el menú superior.
  - La información del enlace puede mostrarse con estilos.
  - Se han añadido pequeños tooltips informativos al pasar el ratón por encima de las opciones disponibles.
- **Corrección de errores**:
  - Se ha corregido un error que provocaba que el programa fallara al detectar una nueva versión y al mostrar la política de privacidad.
  - Se ha corregido un error que obligaba a introducir nuevamente la URL del video al marcar la casilla de 'Título Real' después de haberlo introducido.
- **Código**:
  - Código corregido y optimizado.

## v2.00
- **Rediseño parcial de la aplicación**:
  - Añadida ventana para la aceptación de Política de Privacidad y Términos y Condiciones de Uso.
  - Activado el uso de la base de datos.
  - Código optimizado y corregido.
  - Eliminado el check de seguimiento, ahora queda activada al aceptar los términos en el comienzo.

## v1.74
- **Actualización automática**:
  - Ahora la aplicación se actualiza automáticamente cuando detecta una nueva versión.
  - Se ha añadido un updater para realizar la actualización.
- **Mejoras en la interfaz**:
  - Se ha readaptado la opción de casilla de verificación 'Título Original' para que no requiera introducir el título de manera obligatoria en caso de estar marcada.
- **Sistema de versiones**:
  - Se ha creado el sistema de versiones para mostrarlo en el updater.
- **Seguimiento de actividad**:
  - Se ha añadido un botón para activar y desactivar el seguimiento de actividad, que almacena únicamente el enlace de descarga, la fecha y el país desde el que se accede, con el fin de mejorar la compatibilidad de la aplicación.
- **Optimización**:
  - El código ha sido corregido y optimizado.

## v1.22
- **Descarga de audio**:
  - Se ha añadido la opción de poder descargar solo el audio de los enlaces en formato MP3.

## v1.12
- **Notificaciones**:
  - Se ha mejorado la visualización de las notificaciones en la aplicación.

## v1.10
- **Notificaciones emergentes**:
  - Se ha añadido una casilla de verificación para desactivar las notificaciones emergentes y mostrarlas dentro de la misma aplicación.
- **Optimización**:
  - El código ha sido corregido y optimizado.

## v0.99
- **Corrección de error**:
  - Se ha corregido un error detectado en la búsqueda en FilmAffinity cuando no existe un año de búsqueda.

## v0.98
- **Búsqueda directa**:
  - Se han añadido botones de enlace con búsqueda directa al título introducido, tanto a YouTube como a FilmAffinity. Acepta marcar la casilla de tráiler para buscar el tráiler en el caso de YouTube.

## v0.88
- **Corrección de error**:
  - Corregido un error que provocaba que en algunos formatos no se añadiera la extensión del vídeo.

## v0.86
- **Corrección de error**:
  - Corregido un error que hacía que se crearan las carpetas por duplicado.

## v0.84
- **Nuevas funciones**:
  - Se añade la función de conversión de video.
- **Correcciones y optimización**:
  - Se corrige un error por el que los videos se nombraban mal en su extensión.
  - Se rediseña el formulario.
  - Se optimiza el código.

## v0.63
- **Corrección de error**:
  - Ya no se mantiene la información del enlace anterior al limpiar el formulario.

## v0.62
- **Mejoras en el formulario**:
  - Añadida función 'Crear Carpeta'.
  - Se ha redistribuido el formulario.